function [nln,nbn]=select(fem)
%SELECT number of local dof of a finite element space
%   NLN=SELECT(FEM) sets the number of local degree
%   of freedom of the FEM space of finite elements.
%
%   [NLN,NBN]=SELECT(FEM) sets the number of local degree
%   of freedom of the FEM space.
%
%   Required: MESSAGGE.

%   F. Saleri, 23.10.02

switch fem
case 'P1'
    nln = 3;
    nbn = 2;
case 'P2'
    nln = 6;
    nbn = 3;
case 'H2'
    nln = 6;
    nbn = 3;
case 'P3'
    nln = 10;
    nbn = 4;
case 'Pi'
    nln = 6;
    nbn = 3;
case 'Pt'
    nln = 7;
    nbn = 3;
case 'B1'
    nln = 4;
    nbn = 2;
case 'Pc'
    nln = 4;
    nbn = 2;
otherwise
    msg = messagge(1);
    error(msg);
end

return